import acrort


def get_dml_template(class_id, connection):
    spec = [
        ('.Typename', 'string', class_id),
        ('^Is', 'string', 'Dml::TypeDescription'),
    ]
    subject = connection.dml.select1(acrort.dml.ViewSpec(acrort.plain.Unit(flat=spec)))
    return subject.DefaultObject


def _flat_template(unit, prefix=''):
    result = []
    if unit.is_data():
        result = [(prefix, unit.type, unit.traits)]
    elif unit.is_array():
        result = [(prefix, None, None)]
    elif unit.is_composite():
        for key, val in unit:
            result.extend(_flat_template(val, prefix + '.' + key))
    return result


def _change_trait(traits, name, value):
    trait_list = [trait for trait in traits if trait[0] != name]
    trait_list.append((name, acrort.plain.Unit(value)))
    return trait_list


def construct_from_template(template, data):
    if not data:
        return template
    patch = []
    for predicate, type, traits in _flat_template(template):
        val = data.get_branch(predicate, None)
        if val is not None:
            if val.is_data():
                if 'IsOptional' in traits:
                    type = val.type
                    if 'is_null' in traits:
                        traits = _change_trait(traits, 'is_null', val.ref is None)
                patch.append((predicate, acrort.plain.Unit(type, val.ref, traits=traits)))
            else:
                patch.append((predicate, val))
    return template.merge(acrort.plain.UnitDiff(patch)) if patch else template
